/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.driver.common;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.InstallerErrorCode;
import oracle.install.commons.base.driver.common.InstallerException;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.interview.common.util.PrereqExecutor;
import oracle.install.commons.base.resource.StringResourceBundle;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.flow.FlowApplication;
import oracle.install.commons.flow.FlowBuilder;
import oracle.install.commons.flow.FlowExecutionMode;
import oracle.install.commons.flow.FlowExecutor;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ApplicationException;
import oracle.install.commons.util.progress.ProgressModel;

public class NodeScaler
extends FlowApplication {
    private boolean showUsageMode;
    private static final Logger logger = Logger.getLogger(NodeScaler.class.getName());
    private boolean silent;
    private boolean executePrereqs;
    private PrereqExecutor prereqExecutor;

    @Override
    protected FlowExecutor getFlowExecutor() {
        return this.executePrereqs && this.prereqExecutor != null ? this.prereqExecutor : super.getFlowExecutor();
    }

    public PrereqExecutor getPrereqExecutor() {
        return this.prereqExecutor;
    }

    public void setPrereqExecutor(PrereqExecutor prereqExecutor) {
        this.prereqExecutor = prereqExecutor;
    }

    @Override
    public void startup(String configPath, String ... args) throws Exception {
        Object setupDriver = SetupDriver.getInstance();
        ((SetupDriver)setupDriver).getProgressUI().setProgressModel(new ProgressModel());
        super.startup(configPath, args);
    }

    public void startup(String appConfig, String flowConfig, String ... args) throws ApplicationException {
        Object setupDriver = SetupDriver.getInstance();
        ((SetupDriver)setupDriver).getProgressUI().setProgressModel(new ProgressModel());
        super.startup(appConfig, flowConfig, (String)null, (Properties)null, args);
    }

    @Override
    protected void showUsage() {
        Object setupDriver = SetupDriver.getInstance();
        ((SetupDriver)setupDriver).showUsage();
        this.showUsageMode = true;
    }

    @Override
    public synchronized void shutdown() {
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        if (platformInfo.isWindows() && (this.showUsageMode || NodeScaler.isCommandLineSwitchEnabled("-silent")) && Boolean.getBoolean("oracle.installer.wait")) {
            super.addApplicationListener(new ApplicationListener(){

                @Override
                public void update(ApplicationEvent e) {
                    Application application = Application.getInstance();
                    Resource resource = application.getResource(StringResourceBundle.class.getName());
                    String message = resource.getString("installer.exit.prompt", "\nPlease press Enter to exit...", new Object[0]);
                    System.out.print(message);
                    try {
                        System.in.read();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            });
        }
        super.shutdown();
    }

    @Override
    protected void processArguments(List<String> args) throws IllegalArgumentException {
        Object setupDriver = SetupDriver.getInstance();
        if (args.contains("-silent")) {
            this.setUIType(UIType.NONE);
            this.silent = true;
        } else if (args.contains("-executePrereqs")) {
            this.executePrereqs = true;
        }
        ((SetupDriver)setupDriver).processCommandLine(args.toArray(new String[0]));
        super.processArguments(args);
    }

    @Override
    protected void run() {
        Object setupDriver = SetupDriver.getInstance();
        Resource resource = super.getResource("oracle.install.commons.base.resource.StringResourceBundle");
        String finishText = resource.getString("wizard.btnFinish.text", null, new Object[0]);
        if (finishText != null) {
            Resource res = super.getDefaultResource();
            res.setProperty("wizard.btnFinish.text", finishText);
        }
        try {
            ((SetupDriver)setupDriver).load();
        }
        catch (SetupDriverException e) {
            throw new InstallerException((Throwable)e, InstallerErrorCode.INSTALLER_INIT_FAILED, new Object[0]);
        }
        FlowBuilder.getInstance().registerFlowData(((SetupDriver)setupDriver).getSetupBean());
        Runtime.getRuntime().addShutdownHook(new Thread((SetupDriver)setupDriver){
            final /* synthetic */ SetupDriver val$setupDriver;
            {
                this.val$setupDriver = setupDriver;
            }

            @Override
            public void run() {
                try {
                    logger.log(Level.INFO, "Unloading Setup Driver");
                    this.val$setupDriver.unload();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        });
        FlowExecutorType executorType = this.silent ? FlowExecutorType.SILENT : FlowExecutorType.INTERACTIVE;
        FlowExecutionMode executionMode = FlowExecutionMode.NEW;
        super.setFlowDataDefaults(((SetupDriver)setupDriver).getCommandLineArgs());
        super.setExecutorType(executorType);
        super.setExecutionMode(executionMode);
        super.run();
    }

    public static abstract class CommandLineOption {
        public static final String EXECUTE_PREREQS = "-executePrereqs";
        public static final String SILENT = "-silent";
    }
}

